<?php

namespace App\Http\Controllers\Api\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Point;
use App\Models\PointSetting;
use App\Models\Member;
use App\Models\Referral;

class CreateController extends Controller
{
    public function index(Request $request) {
    	//get point settings
    	$point_settings = PointSetting::where('merchant_id', $request->merchantCode)->whereStatus(1)->first();

        if($point_settings == null) {
            return $this->failResponse("Cannot transact. Please check point settings");
        }

    	$computed_points = $this->computePoints($point_settings, $request->amount);
        
        return $computed_points;

    	$point = new Point();
    	$point->point_setting_id = $point_settings->id;
    	$point->merchant_id = $request->merchantCode;
        $point->user_id = (int)$request->id;
        $point->reference = $request->orNumber;
        $point->amount = $request->amount;
        $point->points = $computed_points["buyer"];
        $point->rebate = $computed_points["rebate"];
        $point->system = $computed_points["system"];
        $point->upline_points = 0;
        $point->accumulated = 0;
        $point->advocacy = $computed_points["foundation"];

        if (!$point->save()) {
            \Log::info(json_encode($point->getErrors()));
        }

        //SYSTEM MAINTENANCE
        $system_maintenance = config('app.system_maintenance');
        $system = $this->getMember($system_maintenance);
        $data = [
            "earned" => $system->earned + $computed_points["system"],
            "total_points" => $system->current_points + $computed_points["system"],
            "current_points" => $system->current_points + $computed_points["system"]
        ];
        $this->updateReferralPoints($data, $system_maintenance);
    	unset($computed_points["rebate"]);
    	unset($computed_points["system"]);

    	//ADVOCACY POINTS
    	$upline_foundation = config('app.upline_foundation');
    	$advocacy = $this->getMember($upline_foundation);
    	$data = [
    		"earned" => $advocacy->earned + $computed_points["foundation"],
    		"total_points" => $advocacy->current_points + $computed_points["foundation"],
    		"current_points" => $advocacy->current_points + $computed_points["foundation"]
    	];

    	$this->updateReferralPoints($data, $upline_foundation);
    	unset($computed_points["foundation"]);

    	$buyer_points = $computed_points["buyer"];

        \Log::info($request->id);

        $member = $this->getMemberStatus($request->id);
        $total_points = $member->current_points + $computed_points["buyer"];
        $current_points_total = $member->current_points + $computed_points["buyer"];
        $member_update = Member::where('id', $request->id)->update(['total_points' => $total_points,'current_points' => $current_points_total]);
        unset($computed_points["buyer"]);
        $upline_1 = Referral::where('user_id', $member->user_id)->first();
        if($upline_1) {
        	$member_1 = $this->getMember($upline_1->user_id);
        	$data = [
        		"earned" => $member_1->earned + $computed_points["level_1"],
        		"total_points" => $member_1->current_points + $computed_points["level_1"],
        		"current_points" => $member_1->current_points + $computed_points["level_1"]
        	];

        	$this->updateReferralPoints($data, $member_1->user_id);
        	unset($computed_points["level_1"]);

        	$upline_2 = Referral::where('user_id', $member_1->user_id)->first();
        	if($upline_2) {
        		$member_2 = $this->getMember($upline_2->user_id);

        		$data = [
	        		"earned" => $member_2->earned + $computed_points["level_2"],
	        		"total_points" => $member_2->current_points + $computed_points["level_2"],
	        		"current_points" => $member_2->current_points + $computed_points["level_2"]
	        	];

	        	$this->updateReferralPoints($data, $member_2->user_id);
        		unset($computed_points["level_2"]);

        		$upline_3 = Referral::where('user_id', $member_2->user_id)->first();
        		if($upline_3) {
        			$member_3 = $this->getMember($upline_3->user_id);

        			$data = [
		        		"earned" => $member_3->earned + $computed_points["level_3"],
		        		"total_points" => $member_3->current_points + $computed_points["level_3"],
		        		"current_points" => $member_3->current_points + $computed_points["level_3"]
		        	];

		        	$this->updateReferralPoints($data, $member_3->user_id);
		        	unset($computed_points["level_3"]);

		        	$upline_4 = Referral::where('user_id', $member_3->user_id)->first();
		        	if($upline_4) {
		        		$member_4 = $this->getMember($upline_4->user_id);

		        		$data = [
			        		"earned" => $member_4->earned + $computed_points["level_4"],
			        		"total_points" => $member_4->current_points + $computed_points["level_4"],
			        		"current_points" => $member_4->current_points + $computed_points["level_4"]
			        	];

			        	$this->updateReferralPoints($data, $member_4->user_id);
			        	unset($computed_points["level_4"]);

			        	$upline_5 = Referral::where('user_id', $member_4->user_id)->first();
			        	if($upline_5) {
		        			$member_5 = $this->getMember($upline_5->user_id);

		        			$data = [
				        		"earned" => $member_5->earned + $computed_points["level_5"],
				        		"total_points" => $member_5->current_points + $computed_points["level_5"],
				        		"current_points" => $member_5->current_points + $computed_points["level_5"]
				        	];

				        	$this->updateReferralPoints($data, $member_5->user_id);
				        	unset($computed_points["level_5"]);
		        		} else {
		        			$this->executeLackingReferral($computed_points);
		        		}
		        	} else {
		        		$this->executeLackingReferral($computed_points);
		        	}
        		} else {
        			$this->executeLackingReferral($computed_points);
        		}
        	} else {
        		$this->executeLackingReferral($computed_points);
        	}
        } else {
        	$this->executeLackingReferral($computed_points);
        }

        $this->storePointImage($request,$point->id);

        return $this->successResponse($buyer_points." points has been added.", null);
    }

    public function computePoints($point_settings, $amount) {
    	$points = $point_settings->rebate * $amount / 100;

    	$bayanihan_percent = 0.6;
    	$buyer_percent = 0.50;
    	$bayanihan_points = $points * $bayanihan_percent;

    	$final_result = [
    		"rebate" => $points,
    		"system" => ($amount * ($point_settings->rebate / 100)) * ($point_settings->system / 100),
    		"buyer" => $buyer_percent * $bayanihan_points,
    		"level_1" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"level_2" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"level_3" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"level_4" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"level_5" => round(($point_settings->member / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP),
    		"foundation" => round(($point_settings->advocacy / 100) * $bayanihan_points, 2 , PHP_ROUND_HALF_UP)
    	];

    	return $final_result;
    }

    public function executeLackingReferral($levels) {
    	$levels = array_values($levels);
    	$default_uplines = config('app.default_uplines');
    	foreach ($levels as $key => $level) {
    		$amount = $level/count($default_uplines[$key]);
    		foreach ($default_uplines[$key] as $key => $default_upline) {
		 		$member = $this->getMember($default_upline);
				$data = [
	        		"earned" => $member->earned + $amount,
	        		"total_points" => $member->current_points + $amount,
	        		"current_points" => $member->current_points + $amount
	        	];
	        	$this->updateReferralPoints($data, $member->user_id);
    		}
    	}
    }
}
