<?php

namespace App\Http\Controllers\Api\Hospital\Speciality;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Speciality;
use App\Models\Doctor;

class ViewController extends Controller
{
    public function index() {
    	$specialities = Speciality::select('specialities.*')
    				->join('speciality_types','specialities.speciality_type_id', 'speciality_types.id')
    				->where('specialities.status',1)->get();

    	$data = [];
    	foreach ($specialities as $key => $speciality) {
    		$data[] = [
    			"id" => (string)$speciality->id,
    			"name" => $speciality->name,
    			"imageUrl" => isset($speciality->image->path) ? config('app.AWS_BUCKET_URL').$speciality->image->path : null,
    		];
    	}

    	return $this->successResponse("Success", $data);
    }

    public function getSpeciality($id) {
    	$doctors = Doctor::whereHas('doctorSpecialities', function($query) use ($id) {
    		$query->where('speciality_id', $id);
    	})->get();

    	$data = [];

    	foreach ($doctors as $key => $doctor) {
    		$doctor_specialties = [];
    		foreach ($doctor->doctorSpecialities as $key => $specialty) {
    			$doctor_specialties[] = $specialty->specialty["name"];
    		}

    		$establishments = [];
    		foreach ($doctor->merchant->establishments as $key => $establishment) {
    			$establishments[] = [
    				"id" => (string)$establishment->id,
                    "name" => $establishment->name
    			];
    		}

    		$reviewsCount = 0;
    		$reviews = [];
    		$totalRatings = 0;
    		foreach ($doctor->doctorAppointments as $key => $doctor_appointments) {
    			if($doctor_appointments != null) {
                    if(isset($doctor_appointments->doctorReview->rate)) {
        				$reviewsCount++;
        				$reviews[$doctor->user_id][$doctor_appointments->doctorReview->rate][] = $doctor_appointments->doctorReview->rate;
                    }
    			}
    		}

    		if(count($reviews) > 0) {
    			$totalRatings = $this->calculateRatings($reviews, $doctor->user_id);
    		}

    		$accredited_hmos = [];
    		foreach ($doctor->doctorPaymentMethods as $key => $payment_method) {
    			$accredited_hmos[] = [
    				"id" => (string)$payment_method->id,
    				"name" => ucwords(str_replace("_"," ",$payment_method->name))
    			];
    		}

    		$data[] = [
    			"id" => (string)$doctor->user_id,
                "firstName" => $doctor->account->firstname,
                "mi" => (isset($doctor->account->middlename[0])) ? $doctor->account->middlename[0] : null,
                "lastName" => $doctor->account->lastname,
                "imageUrl" => isset($doctor->image->path) ? config('app.AWS_BUCKET_URL').$doctor->image->path : null,
                "specialities" => implode(",", $doctor_specialties),
                "hospitals" => $establishments,
                "totalRatings" => $totalRatings,
                "reviewsCount" => $reviewsCount,
                "consultationFee" => $doctor->minimum_consultation_fee.' - '.$doctor->maximum_consultation_fee,
                "accreditedHMOs" => $accredited_hmos
    		];
    	}
    	return $this->successResponse("Success", $data);
    }
}
