<?php

namespace App\Http\Controllers\Api\Hospital\Doctor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Doctor;
use App\Models\DoctorAppointment;
use Carbon\Carbon;

class ViewController extends Controller
{
    public function index($id) {
    	$doctor = Doctor::where('user_id',$id)->first();

    	$doctor_specialties = [];
		foreach ($doctor->doctorSpecialities as $key => $specialty) {
			$doctor_specialties[] = $specialty->specialty["name"];
		}

		$establishments = [];
		foreach ($doctor->merchant->establishments as $key => $establishment) {
			$establishments[] = [
				"id" => (string)$establishment->id,
                "name" => $establishment->name,
                "location" => [
                    "latitude" => (double)$establishment->latitude,
                    "longitude" => (double)$establishment->longitude,
                    "address" => $establishment->address
                ]
			];
		}

		$reviewsCount = 0;
		$reviews = [];
		$totalRatings = 0;
        $reviews_data = [];
		foreach ($doctor->doctorAppointments as $key => $doctor_appointments) {
			if($doctor_appointments != null) {
                if(isset($doctor_appointments->doctorReview->rate)) {
                    $reviewsCount++;
                    $reviews[$doctor->user_id][$doctor_appointments->doctorReview->rate][] = $doctor_appointments->doctorReview->rate;
                    $reviews_data[] = [
                        "id" => (string)$doctor_appointments->doctorReview->id,
                        "user" => [
                            "id" => (string)$doctor_appointments->doctorReview->member->user->id,
                            "firstName" => $doctor_appointments->doctorReview->member->user->firstname,
                            "mi" => (isset($doctor_appointments->doctorReview->member->user->middlename[0])) ? $doctor_appointments->doctorReview->member->user->middlename[0] : null,
                            "lastName" => $doctor_appointments->doctorReview->member->user->lastname,
                            "imageUrl" => isset($doctor_appointments->doctorReview->member->user_images[0]->path) ? config('app.AWS_BUCKET_URL').$doctor_appointments->doctorReview->member->user_images[0]->path : null,
                        ],
                        "rating" => (int)$doctor_appointments->doctorReview->rate,
                        "content" => $doctor_appointments->doctorReview->comment,
                        "timestamp" => $doctor_appointments->doctorReview->created_at->format('Y-m-d H:i:s')
                    ];
                }
			}
		}

		if(count($reviews) > 0) {
			$totalRatings = $this->calculateRatings($reviews, $doctor->user_id);
		}

		$accredited_hmos = [];
		foreach ($doctor->doctorPaymentMethods as $key => $payment_method) {
			$accredited_hmos[] = [
				"id" => (string)$payment_method->id,
				"name" => ucwords(str_replace("_"," ",$payment_method->name))
			];
		}

		$bookingDateTime = $this->getBookingDateTime($this->getTimes($doctor->doctor_schedule));

		$data = [
			"id" => (string)$doctor->user_id,
            "firstName" => $doctor->account->firstname,
            "mi" => (isset($doctor->account->middlename[0])) ? $doctor->account->middlename[0] : null,
            "lastName" => $doctor->account->lastname,
            "imageUrl" => isset($doctor->image->path) ? config('app.AWS_BUCKET_URL').$doctor->image->path : config('app.AWS_BUCKET_URL')."web/img/doctor_default.jpg",
            "specialities" => implode(",", $doctor_specialties),
            "hospitals" => $establishments,
            "consultationFee" => $doctor->minimum_consultation_fee.'-'.$doctor->maximum_consultation_fee,
            "accreditedHMOs" => $accredited_hmos,
            "timings" => [
            	"times" => array_values($this->getTimes($doctor->doctor_schedule)),
            	"currentDayTimeIndex" => (int) date('w', strtotime('Today'))
            ],
            "biograph" => $doctor->bio,
            "contact_number" => $doctor->contact_number,
            "reviewsCount" => $reviewsCount,
            "bookingDateTime" => $bookingDateTime,
            "totalRatings" => $totalRatings,
		];

        if($totalRatings > 0) {
            $data["reviews"] = $reviews_data;
        }

        return $this->successResponse("Okay", $data);
    }

    public function getReviews($id) {
    	$doctor_appointments = DoctorAppointment::where('doctor_id', $id)->get();
    	$data = [];

    	foreach ($doctor_appointments as $key => $doctor_appointment) {
    		$data[] = [
    			'id' => (string) $doctor_appointment->doctorReview->id,
                'user' => (Object)[
                    'id' => (string)$doctor_appointment->member->user->id,
                    'firstName' => $doctor_appointment->member->user->firstname,
                    'mi' => $doctor_appointment->member->user->middlename,
                    'lastName' => $doctor_appointment->member->user->lastname,
                    'imageUrl' => isset($doctor_appointment->member->user->images[0]->path) ? config('app.AWS_BUCKET_URL').$doctor_appointment->member->user->images[0]->path : null,
                ],
                'rating' => (int) $doctor_appointment->doctorReview->rate,
                'content' => $doctor_appointment->doctorReview->comment,
                'timestamp' => date('Y-m-d H:i:s', strtotime($doctor_appointment->doctorReview->created_at))
    		];
    	}

    	return $this->successResponse("[SERVER] Reviews for doctor ".$id, $data);
    }

    public function getBookingDateTime($schedules) {
    	$now = Carbon::now();
        $start = $now->format('w') == 0 ? 'Today' : 'last sunday';
        $counter = Carbon::parse($start);
        $startDate = Carbon::parse($start);  
        $endDate = Carbon::parse($start)->addDays(7);

    	$map = [];
    	$map2 = [];
    	for($i = 1; $i <= 7; $i++) {
    		$date = Carbon::parse($start)->addDays($i + 1);
    		$schedule_selected = $schedules[strtolower($date->isoFormat('dddd'))];

    		if($schedule_selected !== null) {
                if($schedule_selected[0] == "Closed") {
                    $am_time = explode(" - ", "09:00 AM - 11:00 AM");
                    $pm_time = explode(" - ", "02:00 PM - 04:00 PM");
                } else {
                    $am_time = explode(" - ", $schedule_selected[0]);
                    $pm_time = explode(" - ", $schedule_selected[1]);
                }
    			
	    		$am_start = isset($am_time[0]) ? $am_time[0] : null;
	    		$am_end = isset($am_time[1]) ? $am_time[1] : null;
	    		$pm_start = isset($pm_time[0]) ? $pm_time[0] : null;
	    		$pm_end = isset($pm_time[1]) ? $pm_time[1] : null;
	    		
                $am_startTime = new Carbon($am_start);
                $am_endTime = new Carbon($am_end);

				$am_time_array = array();
				while ($am_startTime->lte($am_endTime)){
				  	$am_time_array[] = $am_startTime->format("h:i A");
				  	$am_startTime->addHour();
				}

				$pm_startTime = new Carbon($pm_start);
				$pm_endTime = new Carbon($pm_end);
				$pm_time_array = array();
				while ($pm_startTime->lte($pm_endTime)){
				  	$pm_time_array[] = $pm_startTime->format("h:i A");
				  	$pm_startTime->addHour();
				}

				$time_array = array_merge($am_time_array, $pm_time_array);

                // if($schedule_selected[0] == "Closed") {
                //     $map2[$i] = $time_array;
                // }

				$map[$i] = $time_array;
    		} else {
    			$map2[$i] = null;
    		}
    	}

    	$data = [ 
            'startDate' => $startDate->toDateString(),
            'endDate' => $endDate->toDateString(), 
            'initialDate' => $now->toDateString(),
            'unselectableWeekDays' => $map2,
            'weekDaySchedule' => $map, 
        ];

        return $data;
    }

    public function getBookingSchedule($id) {
    	$doctor = Doctor::find($id);

    	return $this->successResponse("success", $this->getBookingDateTime($this->getTimes($doctor->doctor_schedule)));
    }
}
