<?php

namespace App\Http\Controllers\Api\Hospital\Doctor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DoctorReview;

class CreateController extends Controller
{
    public function index(Request $request) {
    	$params = [
    		'appointment_id' => (int)$request->appointment_id,
	        'rate' => (int)$request->rating,
	        'comment' => $request->content,
	        'user_id'  => (int)auth()->user()->id
    	];

        $doctor_review = DoctorReview::where('appointment_id', $request->appointment_id)->where('user_id', auth()->user()->id)->count();
        if($doctor_review > 0) {
            return $this->successResponse("Done rating this doctor in this appointment.", null);
        }

    	$doctor_review = new DoctorReview($params);
    	$doctor_review->save();

    	return $this->successResponse("Ratings and reviews successfully save.", null);
    }
}
