<?php

namespace App\Http\Controllers\Api\Hospital\Appointment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DoctorAppointment;
use Carbon\Carbon;

class ViewController extends Controller
{
    public function index() {
    	$doctor_appointments = DoctorAppointment::where('user_id', auth()->user()->id)->get();

    	$appointmentMap = [];
    	foreach ($doctor_appointments as $key => $appointment) {
            \Log::info("SHERWIN ".$appointment->doctorReview);
    		$appointment_date_time = Carbon::parse($appointment->date_time);
    		$date = $appointment_date_time->toDateString();
    		$time = $appointment_date_time->format("h:i A");

    		$doctor_specialties = [];
            if(isset($appointment->doctor->doctorSpecialities)) {
                foreach ($appointment->doctor->doctorSpecialities as $key => $specialty) {
                    $doctor_specialties[] = $specialty->specialty["name"];
                }
            }

            if(!isset($appointment->doctor->user_id)) {
                continue;
            }

    		$appointmentMap[$date][] = [
    			"id" => (string)$appointment->id,
    			"doctor" => [
    				"id" => (string)$appointment->doctor->user_id,
    				"firstName" => $appointment->doctor->account->firstname,
                    "mi" => isset($appointment->doctor->account->middlename[0]) ? $appointment->doctor->account->middlename[0] : "",
                    "lastName" => $appointment->doctor->account->lastname,
                    "imageUrl" => isset($appointment->member->user->images[0]->path) ? config('app.AWS_BUCKET_URL').$appointment->member->user->images[0]->path : null,
                    "specialities" => implode(",", $doctor_specialties),
                    "contactNumber" => $appointment->doctor->contact_number
    			],
                "referenceNumber" => str_replace("REF#:","",$appointment->reference_id),
    			"date" => $date,
    			"time" => $time,
    			"notes" => $appointment->notes,
    			"paymentMethod" => $appointment->payment_method,
    			"hmoName" => null,
    			"status" => ($appointment->status == "approved") ? "ACCEPTED" : strtoupper($appointment->status),
    			"dateRequested" => $appointment->created_at->format('Y-m-d H:i:s'),
    			"dateStatusUpdated" => $appointment->updated_at->format('Y-m-d H:i:s'),
    			"hospital" => [
    				"id" => (string)$appointment->doctor->merchant->establishments[0]->id,
                    "name" => $appointment->doctor->merchant->establishments[0]->name,
                    "imageUrl" => isset($appointment->doctor->merchant->establishments[0]->image->path) ? config('app.AWS_BUCKET_URL').$appointment->doctor->merchant->establishments[0]->image->path : null,
                    "location" => [
                        "latitude" => (double)$appointment->doctor->merchant->establishments[0]->latitude,
                        "longitude" => (double)$appointment->doctor->merchant->establishments[0]->longitude,
                        "address" => $appointment->doctor->merchant->establishments[0]->address
                    ]
    			],
                "review" => [
                    "id" => isset($appointment->doctorReview->id) ? (string)$appointment->doctorReview->id : null,
                    "rating" =>isset($appointment->doctorReview->rate) ? (double)$appointment->doctorReview->rate : null,
                    "content" => isset($appointment->doctorReview->comment) ? $appointment->doctorReview->comment : null,
                ]
    		];
    	}

    	$data = [
    		"appointmentMap" => (count($appointmentMap) > 0) ? $appointmentMap : (Object)[]
    	];

    	return $this->successResponse(null, $data);
    }
}
