<?php

namespace App\Http\Controllers\Api\Hospital\Appointment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DoctorAppointment;
use Carbon\Carbon;

class CreateController extends Controller
{
    public function index(Request $request) {
    	$date_time = date('Y-m-d H:i:s', strtotime($request->date." ".$request->time));
    	$params = [
    		'doctor_id' => $request->doctorId,
	        'user_id' => auth()->user()->id,
	        'date_time' => $date_time,
	        'appointment_id' => $this->generateAppointmentId(),
	        'reference_id' => $this->generateReferenceId(),
	        'payment_method' => $request->paymentMethod,
	        'status' => 'pending'
    	];

    	$doctor_appointment = new DoctorAppointment($params);
    	$doctor_appointment->save();

    	return $this->successResponse("Please wait for doctor's approval for your appointment.", null);
    }

    public function generateReferenceId() {
    	$length = 10;    
		$reference_id = "REF#:".substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
    	return $reference_id;
    }

    public function generateAppointmentId() {
    	$length = 10;    
		$reference_id = "APT#:".substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'),1,$length);
    	return $reference_id;
    }
}
