<?php

namespace App\Http\Controllers\Api\Driver\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TransactionOrder;


class ViewController extends Controller
{
    public function index(Request $request) {
    	$query = TransactionOrder::where('driver_id', auth()->user()->account->id)->where('payment_method' , 'COD');
    	if($request->statusType == "ONGOING") {
    		$status = ["prepared", "otw", "arrived"];
    	} else {
    		$status = ["completed"];
    	}

    	$transaction_orders = $query->whereIn('status',$status)->get();

    	$data = [];
    	foreach ($transaction_orders as $key => $transaction_order) {
            $total = isset($transaction_order->delivery_amount) ? $transaction_order->delivery_amount : 0;
            foreach ($transaction_order->orders as $key => $order) {
                $total+= $order->quantity * $order->product->price;
            }
    		$data[] = [
    			"id" => str_replace("REF#:","",$transaction_order->reference_id),
    			"merchant" => [
    				"id" => (string)$transaction_order->establishment->id,
    				"name" => $transaction_order->establishment->name,
    				"imageUrl" => isset($transaction_order->establishment->image->url) ? $transaction_order->establishment->image->url : null,
    				"attributes" => null,
    				"location" => [
    					"latitude" => (double)$transaction_order->establishment->latitude,
    					"longitude" => (double)$transaction_order->establishment->longitude,
    					"address" => $transaction_order->establishment->address,
    				]
    			],
    			"recipient" => [
    				"id" => (string)$transaction_order->user->user_id,
    				"firstName" => $transaction_order->user->user->firstname,
    				"mi" => (isset($transaction_order->user->user->middlename[0])) ? $transaction_order->user->user->middlename[0] : null,
    				"lastName" => $transaction_order->user->user->lastname,
    				"imageUrl" => (isset($transaction_order->user->user_image[0]->url)) ? $transaction_order->user->user_image[0]->url : null,
    				"contactNumber" => $transaction_order->user->mobile_number
    			],
    			"deliveryLocation" => [
    				"latitude" => (double)$transaction_order->latitude,
    				"longitude" => (double)$transaction_order->longitude,
    				"address" => $transaction_order->address
    			],
    			"totalItems" => $transaction_order->orders->count(),
    			"totalPrice" => $total,
    			"status" => ($transaction_order->status == "completed") ? "DELIVERED" : strtoupper($transaction_order->status),
    			"dateOrdered" => $transaction_order->created_at->format('Y-m-d H:i:s'),
    			"mode" => "ASAP",
    			"dateScheduled" => $transaction_order->created_at->format('Y-m-d H:i:s'),
    			"cashOnHand" => $transaction_order->cash_on_hand,
    			"notes" => $transaction_order->notes
    		];
    	}

    	return $this->successResponse("Success", $data);
    }

    public function getOrder($id) {
    	$transaction_order = TransactionOrder::where('reference_id', "REF#:".$id)->first();

    	$items = [];
    	foreach ($transaction_order->orders as $key => $order) {
    		$items[] = [
    			"item" => [
	    			"id" => (string)$order->product->id,
	    			"name" => $order->product->name,
	    			"imageUrl" => (isset($order->product->image->url)) ? $order->product->image->url : null,
	    			"description" => $order->product->description,
	    			"price" => (double)$order->product->price
    			],
    			"quantity" => (int)$order->quantity
    		];
    	}

    	$data = [
    		"id" => $id,
    		"items" => $items,
    		"merchant" => [
				"id" => (string)$transaction_order->establishment->id,
				"name" => $transaction_order->establishment->name,
				"imageUrl" => isset($transaction_order->establishment->image->url) ? $transaction_order->establishment->image->url : null,
				"attributes" => null,
				"location" => [
					"latitude" => (double)$transaction_order->establishment->latitude,
					"longitude" => (double)$transaction_order->establishment->longitude,
					"address" => $transaction_order->establishment->address,
				]
			],
			"recipient" => [
				"id" => (string)$transaction_order->user->id,
				"firstName" => $transaction_order->user->user->firstname,
				"mi" => (isset($transaction_order->user->user->middlename[0])) ? $transaction_order->user->user->middlename[0] : null,
				"lastName" => $transaction_order->user->user->lastname,
				"imageUrl" => (isset($transaction_order->user->user_image[0]->url)) ? $transaction_order->user->user_image[0]->url : null,
				"contactNumber" => $transaction_order->user->mobile_number
			],
			"deliveryLocation" => [
				"latitude" => (double)$transaction_order->latitude,
				"longitude" => (double)$transaction_order->longitude,
				"address" => $transaction_order->address
			],
			"totalItems" => $transaction_order->orders->count(),
			"totalPrice" => null,
			"status" => ($transaction_order->status == "completed") ? "DELIVERED" : strtoupper($transaction_order->status),
			"dateOrdered" => $transaction_order->created_at->format('Y-m-d H:i:s'),
			"mode" => "ASAP",
			"dateScheduled" => $transaction_order->created_at->format('Y-m-d H:i:s'),
			"cashOnHand" => (double)$transaction_order->cash_on_hand,
			"notes" => $transaction_order->notes
    	];

    	$total = isset($transaction_order->delivery_amount) ? $transaction_order->delivery_amount : 0;
        // $total = 0;
		foreach ($transaction_order->orders as $key => $order) {
			$total+= $order->quantity * $order->product->price;
		}
		$data["totalPrice"] = $total;
    	return $this->successResponse("success", $data);
    }
}
