<?php

namespace App\Http\Controllers\Api\Driver\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TransactionOrder;
use App\Models\Driver;

class UpdateController extends Controller
{
    public function index($id, Request $request) {
    	$transactionOrder = TransactionOrder::where('reference_id', "REF#:".$id)->first();

    	$orders_data = array(
            "function" => "ORDERS",
            "function_id" => (string)$transactionOrder->user_id,
            "id" => str_replace("REF#:","",$transactionOrder->reference_id),
            "merchant" => array(
                "id" => (string)$transactionOrder->establishment->id,
                "name" => $transactionOrder->establishment->name,
                "location" => array(
                    "latitude" => (double)$transactionOrder->establishment->latitude,
                    "longitude" => (double)$transactionOrder->establishment->longitude,
                    "address" => $transactionOrder->establishment->address
                )
            ),
            "deliveryLocation" => array(
                "latitude" => (double)$transactionOrder->latitude,
                "longitude" => (double)$transactionOrder->longitude,
                "address" => $transactionOrder->address
            ),
            "totalItems" => (int)$transactionOrder->orders->sum('quantity'),
            "totalPrice" => null,
            "status" => ($request->status == "completed") ? "DELIVERED" : strtoupper($request->status),
            "dateOrdered" => $transactionOrder->created_at->format("Y-m-d H:i:s")
        );

        $order_details_data = array(
            "function" => "ORDER-DETAIL",
            "function_id" => str_replace("REF#:","",$transactionOrder->reference_id),
            "id" => str_replace("REF#:","",$transactionOrder->reference_id),
            "merchant" => $orders_data["merchant"],
            "deliveryLocation" => $orders_data["deliveryLocation"],
            "cashOnHand" => $transactionOrder->cash_on_hand,
            "dateOrdered" => $transactionOrder->created_at->format("Y-m-d H:i:s"),
            "mode" => "ASAP",
            "notes" => $transactionOrder->notes,
            "deliveryFee" => (double)$transactionOrder->delivery_amount,
            "paymentMethod" => str_replace(" ","",strtoupper($transactionOrder->payment_method)),
            "items" => null
        );

        $total_price = 0;
        foreach ($transactionOrder->orders as $key => $order) {
            $total = $order->product->price * $order->quantity;
            $total_price += $total;
        }

        $orders_data["totalPrice"] = (double)$total_price;

        if($transactionOrder->driver_id != null) {
            $driver = Driver::where('id', $transactionOrder->driver_id)->first();

            $order_details_data["driver"] = [
                "vehicle" => [
                    "id" => (string)$driver->vehicle->id,
                    "make" => $driver->vehicle->model,
                    "plateNumber" => $driver->vehicle->plate_number
                ],
                "id" => (string)$driver->id,
                "cardNumber" => null,
                "firstName" => $driver->user->firstname,
                "mi" => (isset($driver->user->middlename[0])) ? $driver->user->middlename[0] : null,
                "lastName" => $driver->user->lastname,
                "contactNumber" => $driver->contact_number,
                "emailAddress" => $driver->user->email,
                "address" => null,
                "username" => $driver->user->username,
                "imageUrl" => isset($driver->image->url) ? $driver->image->url : null
            ];
        } 

        if($request->status == "DELIVERED") {
        	$status = "completed";
        } else {
        	$status = strtolower($request->status);
        }

        TransactionOrder::where('reference_id', "REF#:".$id)->update(['status' => $status]);

        $driver_order_data = array(
            "function" => "DELIVERIES",
            "function_id" => (string)$request->driver_id,
            "id" => str_replace("REF#:","",$transactionOrder->reference_id),
            "merchant" => $orders_data["merchant"],
            "recipient" => array(
                "id" => (string)$transactionOrder->account->id,
                "firstName" => $transactionOrder->account->firstname,
                "mi" => isset($transactionOrder->account->middlename[0]) ? $transactionOrder->account->middlename[0] : "",
                "lastName" => $transactionOrder->account->lastname,
                "contactNumber" => $transactionOrder->account->member->mobile_number,
                "emailAddress" => $transactionOrder->account->email,
                "address" => $transactionOrder->account->member->address,
                "username" => $transactionOrder->account->username,
                "imageUrl" => isset($transactionOrder->account->images[0]->path) ? $transactionOrder->account->images[0]->url : null, 
            ),
            "deliveryLocation" => $orders_data["deliveryLocation"],
            "totalItems" => (int)$transactionOrder->orders->sum('quantity'),
            "totalPrice" => $orders_data["totalPrice"],
            "status" => strtoupper($request->status),
            "dateOrdered" => $transactionOrder->created_at->format("Y-m-d H:i:s")
        );

        //Emit Socket for Driver DELIVIERIES
        $this->emitSocket($driver_order_data);

        //Emit Socket ORDERS
        $orders_data["status"] = strtoupper($request->status);
        $this->emitSocket($orders_data);

        //Emit Socket ORDERS
        $order_details_data["status"] = strtoupper($request->status);
        $this->emitSocket($order_details_data);

    	return $this->successResponse("Success", null);
    }
}
