<?php

namespace App\Http\Controllers\Api\Conversation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Conversation;
use DB;

class ViewController extends Controller
{
    public function index() {
    	$ids = Conversation::groupBy('conversation_id')
    			->select(DB::raw('max(id) as id'))
    			->get()
    			->pluck('id');

    	$conversations = Conversation::whereIn('id', $ids)->get();

    	$data = [];

    	foreach ($conversations as $key => $conversation) {
    		$data[] = [
    			"id" => $conversation->conversation_id,
    			"peer" => [
    				"id" => (string)$conversation->user->id,
				    "cardNumber" => null,
				    "firstName" => $conversation->user->firstname, 
				    "mi" => isset($conversation->user->middlename[0]) ? $conversation->user->middlename[0] : null, 
				    "lastName" => $conversation->user->lastname,
				    "contactNumber" => null,
				    "emailAddress" => null,
				    "address" => null,
				    "username" => null,
				    "imageUrl" => isset($conversation->user->images[0]) ? $conversation->user->images[0]->url : config('app.AWS_BUCKET_URL')."web/img/doctor_default.jpg"
    			],
    			"lastMessage" => [
    				"id" => (string)$conversation->message_id,
				    "senderId" => $conversation->sender_id,
				    "content" => $conversation->content,
				    "timestamp" => $conversation->created_at,
				    "type" => $conversation->type,
				    "status" => $conversation->status
    			]
    		];
    	}

    	return $this->successResponse('Success', $data);
    }

    public function messages($id) {
    	$conversations = Conversation::where('conversation_id', $id)->get();
    	$data = [];
    	foreach ($conversations as $key => $conversation) {
    		$data[] = [
    			"id" => (string)$conversation->message_id,
			    "senderId" => (string)$conversation->sender_id,
			    "content" => $conversation->content,
			    "timestamp" => (string)$conversation->created_at,
			    "type" => $conversation->type,
			    "status" => $conversation->status
    		];
    	}
    	return $this->successResponse("Success", $data);
    }
}
