<?php

namespace App\Http\Controllers\Api\Conversation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Conversation;

class CreateController extends Controller
{
    public function index(Request $request) {
    	$ids = explode("&", $request->conversationId);
    	$params = [
    		"conversation_id" => $request->conversationId,
    		"message_id" => $request->messageId,
    		"sender_id" => auth()->user()->id,
    		"to_id" => $ids[1],
    		"content" => $request->content,
    		"type" => $request->type,
    		"status" => "SENT"
    	];

    	$conversation = new Conversation($params);
    	$conversation->save();

    	$conversation_data = array(
            "function" => "CONVERSATION",
            "function_id" => (string)auth()->user()->id,
            "id" => $conversation->conversation_id,
			"peer" => array(
				"id" => (string)$conversation->user->id,
			    "cardNumber" => null,
			    "firstName" => $conversation->user->firstname, 
			    "mi" => isset($conversation->user->middlename[0]) ? $conversation->user->middlename[0] : null, 
			    "lastName" => $conversation->user->lastname,
			    "contactNumber" => null,
			    "emailAddress" => null,
			    "address" => null,
			    "username" => null,
			    "imageUrl" => isset($conversation->user->images[0]) ? $conversation->user->images[0]->url : config('app.AWS_BUCKET_URL')."web/img/doctor_default.jpg"
			),
			"lastMessage" => array(
				"id" => (string)$conversation->message_id,
			    "senderId" => (string)$conversation->sender_id,
			    "content" => $conversation->content,
			    "timestamp" => (string)$conversation->created_at,
			    "type" => $conversation->type,
			    "status" => $conversation->status
			)
        );

    	//Emit Socket for Conversation
        $this->emitSocket($conversation_data);

        $chat_id = (string)$ids[0]."&".(string)$ids[1];
        $chat_data = array(
        	"function" => "CHAT",
            "function_id" => $request->conversationId,
        	"id" => (string)$conversation->message_id,
		    "senderId" => (string)$conversation->sender_id,
		    "content" => $conversation->content,
		    "timestamp" => (string)$conversation->created_at,
		    "type" => $conversation->type,
		    "status" => $conversation->status
        );
    	//Emit Socket for Chat
        $this->emitSocket($chat_data);

    	return $this->successResponse("Success", null);
    }
}
