<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\MerchantCashier;
use App\Models\Merchant;
use App\Models\Member;

class ViewController extends Controller
{
    public function index(Request $request)
    {
        $username = $request->username; //the input field has name='username' in form

        if (filter_var($username, FILTER_VALIDATE_EMAIL)) {
            $credentials = [
                "email" => $request->username,
                "password" => $request->password,
            ];
        } else {
            $credentials = [
                "username" => $request->username,
                "password" => $request->password,
            ];
        }

        $credentials["usertype"] = "member";
        $lacking = false;

        if (!auth()->attempt($credentials)) {
            return $this->failResponse("Invalid username or password.");
        }

        $tokenResult = auth()
            ->user()
            ->createToken("PPLUS APP");
        $token = $tokenResult->token;
        $token->save();

        if (!isset(auth()->user()->member->card_number)) {
            $lacking = true;
            $params["card_number"] = $this->generateCardNumber();
        }

        if (!isset(auth()->user()->member->referral_code)) {
            $lacking = true;
            $params["referral_code"] = $this->generateReferralCode();
        }

        if ($lacking == true) {
            $params["user_id"] = auth()->user()->id;
            $params["member_type_id"] = 8;
            $params["member_id"] = $this->generateRandomMemberId();
            $params["birthdate"] = "1970-01-01";
            $params["gender"] = "Male";
            $params["marital_status"] = "Single";
            $params["citizenship"] = "Filipino";
            $params["mobile_number"] = "+63920";
            $params["occupation"] = "None";
            $params["address"] = "None";
            $member = new Member($params);
            $member->save();
        }

        $member = Member::where("user_id", "=", auth()->user()->id)->first();

        $data = (object) [
            "id" => (string) auth()->user()->id,
            "firstName" => auth()->user()->firstname,
            "lastName" => auth()->user()->lastname,
            "mi" => isset(auth()->user()->middlename[0])
                ? auth()->user()->middlename[0]
                : null,
            "username" => auth()->user()->username,
            "imageUrl" => isset(auth()->user()->images[0]->path)
                ? config("app.AWS_BUCKET_URL") . auth()->user()->images[0]->path
                : null,
            "emailAddress" => auth()->user()->email,
            "address" => isset(auth()->user()->member->address)
                ? auth()->user()->member->address
                : "",
            "contactNumber" => isset(auth()->user()->member->mobile_number)
                ? auth()->user()->member->mobile_number
                : "",
            "cardNumber" => isset(auth()->user()->member->card_number)
                ? (string) auth()->user()->member->card_number
                : $params["card_number"],
            "referralCode" => isset(auth()->user()->member->referral_code)
                ? base64_encode(auth()->user()->member->referral_code)
                : $params["referral_code"],
            "registrationStatus" => $member->registration_status,
            "city" => $member->city,
            "streetAddress" => $member->street_address,
            "building" => $member->building,
            "province" => $member->province,
            "birthday" => $member->birthdate->format('Y/n/j'),  
        ];

        return $this->successResponseAuth(
            "Successfully login.",
            $data,
            (string) $tokenResult->accessToken
        );
    }

    public function user()
    {
        $tokenResult = auth()
            ->user()
            ->createToken("PPLUS APP");
        $token = $tokenResult->token;
        $token->save();

        $member = Member::where("user_id", "=", auth()->user()->id)->first();

        $data = (object) [
            "id" => (string) auth()->user()->id,
            "firstName" => auth()->user()->firstname,
            "lastName" => auth()->user()->lastname,
            "mi" => auth()->user()->middlename,
            "username" => isset(auth()->user()->middlename[0])
                ? auth()->user()->middlename[0]
                : null,
            "imageUrl" => isset(auth()->user()->images[0]->path)
                ? config("app.AWS_BUCKET_URL") . auth()->user()->images[0]->path
                : null,
            "emailAddress" => auth()->user()->email,
            "address" => auth()->user()->member->address,
            "contactNumber" => auth()->user()->member->mobile_number,
            "cardNumber" => (string) auth()->user()->member->card_number,
            "referralCode" => base64_encode(
                auth()->user()->member->referral_code
            ),
            "registrationStatus" => (string) $member->registration_status,
            "city" => $member->city,
            "streetAddress" => $member->street_address,
            "building" => $member->building,
            "province" => $member->province,
            "birthday" => $member->birthdate->format('Y/n/j'),  
        ];

        return $this->successResponse("Authenticated", $data);
    }

    // Generate Card Number
    public function generateCardNumber()
    {
        $code = $this->generateNumericCode();
        $member = Member::where("card_number", $code)->first();

        if (isset($member)) {
            $this->generateNumericCode();
        }

        return $code;
    }

    // Generate 16 digits Numberic Code
    public function generateNumericCode()
    {
        $code = "";
        for ($i = 0; $i < 16; $i++) {
            $code .= mt_rand(0, 9);
        }

        return $code;
    }

    // Generate Referral Code
    public function generateReferralCode()
    {
        $code = $this->generateAlphaNumeric(7);
        $member = Member::where("referral_code", $code)->first();

        if (isset($member)) {
            $this->generateAlphaNumeric(7);
        }

        return $code;
    }

    // Generate Alpha Numberic
    public function generateAlphaNumeric($limit)
    {
        $code = substr(
            base_convert(sha1(uniqid(mt_rand())), 16, 36),
            0,
            $limit
        );

        return strtoupper($code);
    }

    public function generateRandomMemberId()
    {
        return $randomNum = substr(str_shuffle("0123456789"), 0, 9);
    }
}
