<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Rules\MatchOldPassword;
use Illuminate\Support\Facades\Hash;

//Add Models
use App\Models\Member;
use App\Models\Referral;
use App\Models\User;
use App\Models\MemberPointTransactions;
use App\Models\BayanihanPointSetting;
use Illuminate\Support\Str;
use Validator;
use DB;

class UpdateController extends Controller
{
    public function index(Request $request) {
    	DB::beginTransaction();

    	$userParams = [
            'firstname' => $request->firstName,
            'lastname' => $request->lastName,
            'middlename' => $request->mi
    	];

    	$user = auth()->user();
    	if($user->update($userParams)) {
    		$memberParams = [
    			"mobile_number" => $request->contactNumber,
    			"address" => $request->address,
                "city" => $request->city,
                "building" => $request->building,
                "street_address" => $request->street,
                "province" => $request->province,
    		];

    		$member = auth()->user()->member;
            if ($member->update($memberParams)) {
            	// commit all update
                DB::commit();

				$data = [
					"id" => (string)auth()->user()->id,
			        "firstName" => auth()->user()->firstname,
			        "lastName" => auth()->user()->lastname,
			        "mi" => isset(auth()->user()->middlename[0]) ? auth()->user()->middlename[0] : null,
			        "username" => auth()->user()->username,
			        "imageUrl" => isset(auth()->user()->images[0]->path) ? config('app.AWS_BUCKET_URL').auth()->user()->images[0]->path : null,
			        "emailAddress" => auth()->user()->email,
			        "address" => auth()->user()->member->address,
			        "contactNumber" => auth()->user()->member->mobile_number,
                    "referralCode" => base64_encode(auth()->user()->member->referral_code),
                    "registrationStatus" => (string) $member->registration_status,
                    "city" => $member->city,
                    "streetAddress" => $member->street_address,
                    "building" => $member->building,
                    "province" => $member->province,
                    "birthday" => $member->birthdate->format('Y/n/j'),    
				];

                return $this->successResponse("Successfully updated.", $data);
            }

            // Rollback and then redirect & back to form with errors
            DB::rollback();

            $errors = array_values($member->getErrors()->toArray());
			return $errors;
    	}

    	$errors = array_values($user->getErrors()->toArray());
    	return $this->failResponse($errors[0][0]);
    }

    public function changePassword(Request $request) {
        $validator = Validator::make($request->all(), [   
            'oldPassword' => ['required', new MatchOldPassword],
            'newPassword' => ['required'],
            'confirmPassword' => ['same:newPassword'],
        ]);

        if ($validator->fails()) { 
        	$errors = array_values($validator->errors()->toArray());
    		return $this->failResponse($errors[0][0]);
        }

        auth()->user()->update(['password' => Hash::make($request->newPassword)]);

        return $this->successResponse("Successfully change password.", null);
    }

    public function updateMembership($id) {
       
        if ($id == null || $id == "") { 
            return $this->failResponse("Invalid ID");
        }
        
        $member = Member::where('user_id',$id)->first();

        if($member->current_points < 200)
        {
            return $this->failResponse("Not Enough Redeemable Points");
        }

        if($member->registration_status == "Premium" || $member->registration_status == "verified")
        {
            return $this->failResponse("Invalid Attempt");
        }

        $params = [
            'registration_status'   => 'Premium', 
            'current_points' => $member->current_points - 200,
        ];

        if (!$member->update($params))
        {

            return $this->failResponse("Upgrade Failed");

        }


        $logParams = [
                    "user_id" => $id,
                    "activity" => "Member Upgrade",
                    "reference_id" => $id,
                    "table" => "members",
                    "remarks" => "Successfully upgraded member.",
                ];

        $this->addLogs($logParams);


        $userUpline = Referral::where('user_id', $id)->first();

        if($userUpline != null)
        {

            MemberPointTransactions::create([

                'reference_id' => "REF# : ".strtoupper(Str::random(10)),
                'user_id'=> $id,
                'points'=> -200,
                'upline_user_id' => $userUpline->user_upline_id,
                'description' => 'Membership Upgrade',
                'type'=> "membership_upgrade"
            ]);  
        }

        $point = BayanihanPointSetting::where('status' , 1)->first();
        $referrer = Referral::where('user_id', $id)->first();

        DB::table('members')
                ->where('user_id', $referrer->user_upline_id)
                ->increment('current_points', (int)$point->points);

        DB::table('members')
                ->where('user_id', $referrer->user_upline_id)
                ->increment('total_points', (int)$point->points);   
        
        return $this->successResponse("Successfully Upgraded.", null);       
    }
}
