<?php

namespace App\Http\Controllers\Api\Auth\Driver;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ViewController extends Controller
{
    public function index(Request $request) {
    	$credentials = request(['username', 'password']);
    	$credentials["usertype"] = "driver";

    	if(!auth()->attempt($credentials))
        return $this->failResponse("Invalid username or password.");
        
    	$tokenResult = auth()->user()->createToken('PPLUS DRIVER');
        $token = $tokenResult->token;
        $token->save();
        
    	$data = [
    		"id" => (string)auth()->user()->id,
    		"firstName" => auth()->user()->firstname,
            "lastName" => auth()->user()->lastname,
    		"mi" => isset(auth()->user()->middlename[0]) ? auth()->user()->middlename[0] : null,
    		"contactNumber" => "920231655",
            "emailAddress" => auth()->user()->account->contact_number,
            "username" => auth()->user()->username,
            "imageUrl" => isset(auth()->user()->images[0]->path) ? config('app.AWS_BUCKET_URL').auth()->user()->images[0]->path : null,
    	];

    	if(isset(auth()->user()->account->vehicle_id)) {
    		$data["vehicle"] = [
    			"id" => (string)auth()->user()->account->vehicle->id,
    			"make" => auth()->user()->account->vehicle->model,
    			"plateNumber" => auth()->user()->account->vehicle->plate_number
    		];
    	}

        return $this->successResponseAuth("Successfully login.", $data, (string)$tokenResult->accessToken);
    }
}
