<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Notifications\SuccessfulRegistration;
//Add Models
use App\Models\Member;
use App\Models\User;
use App\Models\BayanihanPointSetting;
use App\Models\MemberPointTransactions;
use App\Models\Referral;
use DB;

class CreateController extends Controller
{
    public function index(Request $request)
    {
        $gender = ["Male", "Female"];

        $request->merge([
            "member_id" => $this->generateMemberId(),
            "card_number" => $this->generateCardNumber(),
            "referral_code" => $this->generateReferralCode(),
            "birthdate" => $request->birthday,
            "usertype" => "member",
            "city" => $request->city ,
            "address" => "not set",
            "member_type_id" => 8,
            "gender" => $gender[array_rand(["Male", "Female"])],
            "citizenship" => "Specify Citizenship",
            "mobile_number" => "+63" . $request->contactNumber,
            "occupation" => "NA",
            "marital_status" => "Select Marital Status",
            "registration_status" => "Regular",
        ]);

        DB::beginTransaction();

        $userParams = [
            "firstname" => $request->firstName,
            "middlename" => $request->mi,
            "lastname" => $request->lastName,
            "username" => $request->username,
            "email" => $request->emailAddress,
            "password" => Hash::make($request->password),
            "usertype" => "member",
        ];

        $check = Member::where(
            "mobile_number",
            "=",
            "+63" . $request->contactNumber
        )->count();
        $user = new User($userParams);

        if ($check > 0) {
            return $this->failResponse("The number has already been taken.");
        } else {
            if ($user->save()) {          
                $params = $request->except([
                    "firstName",
                    "mi",
                    "lastName",
                    "username",
                    "emailAddress",
                    "password",
                    "deviceInfo",
                ]);
                $params["user_id"] = $user->id;
                $member = new Member($params);

                if (!$member->save()) {
                    // Rollback and then redirect & back to form with errors
                    DB::rollback();

                    $errors = array_values($member->getErrors()->toArray());
                    return $this->failResponse($errors[0][0]);
                }

                //ASSIGN ROLE
                $this->assignRole($user);

                DB::commit();

                $user->notify(new SuccessfulRegistration());

                $tokenResult = $user->createToken("PPLUS APP");
                $token = $tokenResult->token;
                $token->save();

                $parent_id = config("app.system_maintenance");
                $userUpline = Member::where('user_id',$parent_id)->first();

                Referral::create([
                    'user_id'        => $user->id,
                    'user_upline_id' => $userUpline->user_id,
                ]);

                $points = $this->getActiveBayanihanPointSetting();

                // Add Referral Points
                $referralPoints = $userUpline->referral_points + $points;

                $userUpline->update([
                    'referral_points' => $referralPoints
                ]);

                MemberPointTransactions::create([

                    'reference_id' => "REF# : ".strtoupper(Str::random(10)),
                    'user_id'=> $user->id,
                    'points'=> 50,
                    'upline_user_id' => $userUpline->user_id,
                    'description' => 'New Referral',
                    'type'=> "new_referral_points"

                ]);  


                $data = [
                    "id" => (string) $user->id,
                    "firstName" => $user->firstname,
                    "lastName" => $user->lastname,
                    "mi" => isset($user->middlename[0])
                        ? $user->middlename[0]
                        : null,
                    "username" => $user->username,
                    "imageUrl" => null,
                    "emailAddress" => $user->email,
                    "address" => $user->member->address,
                    "city" => $user->member->city,
                    "birthday" => $user->member->birthdate->format('Y/n/j'),
                    "referralCode" => base64_encode($user->member->referral_code),
                    "contactNumber" => $user->member->mobile_number,
                    "registrationStatus" => "Regular",
                ];

                return $this->successResponseAuth(
                    "Successfully register.",
                    $data,
                    (string) $tokenResult->accessToken
                );
            }
        }

        $errors = array_values($user->getErrors()->toArray());
        return $this->failResponse($errors[0][0]);
    }

    // Generate Member ID according based on last member_id
    public function generateMemberId()
    {
        $generated_id = Member::select(["member_id"])
            ->orderBy("created_at", "desc")
            ->first();

        return $generated_id["member_id"] + 1;
    }

    // Generate Card Number
    public function generateCardNumber()
    {
        $code = $this->generateNumericCode();
        $member = Member::where("card_number", $code)->first();

        if (isset($member)) {
            $this->generateNumericCode();
        }

        return $code;
    }

    // Generate 16 digits Numberic Code
    public function generateNumericCode()
    {
        $code = "";
        for ($i = 0; $i < 16; $i++) {
            $code .= mt_rand(0, 9);
        }

        return $code;
    }

    // Generate Referral Code
    public function generateReferralCode()
    {
        $code = $this->generateAlphaNumeric(7);
        $member = Member::where("referral_code", $code)->first();

        if (isset($member)) {
            $this->generateAlphaNumeric(7);
        }

        return $code;
    }

    // Generate Alpha Numberic
    public function generateAlphaNumeric($limit)
    {
        $code = substr(
            base_convert(sha1(uniqid(mt_rand())), 16, 36),
            0,
            $limit
        );

        return strtoupper($code);
    }

    function dateFormat($date)
    {
        return date("Y-m-d", strtotime($date));
    }

    public function getActiveBayanihanPointSetting()
    {
        $points = BayanihanPointSetting::whereStatus(1)->value('points');

        return isset($points) ? $points : 50;
    }
}
